# Setup Admin di cPanel Node.js

Dokumen ini menjelaskan cara setup admin untuk aplikasi afiliasi di cPanel Node.js.

## Metode Baru: Auto-Setup Admin (Direkomendasikan)

Sistem baru ini akan otomatis mendeteksi jika admin belum ada dan mengarahkan ke halaman setup yang user-friendly.

### Langkah-langkah:

1. **Upload semua file aplikasi ke cPanel**
   - Upload semua file kecuali `node_modules/` dan `affiliate.db`
   - Pastikan file `.env` sudah terupload

2. **Install Dependencies**
   ```bash
   npm install
   ```

3. **Start Aplikasi**
   - Klik "Start" di Node.js App

4. **Setup Admin Pertama Kali**
   - Buka aplikasi di browser
   - Sistem akan otomatis redirect ke halaman setup admin
   - Isi form setup dengan data admin:
     - Nama Lengkap
     - Username
     - Email
     - Password (minimal 6 karakter)
     - Konfirmasi Password
   - Klik "Buat Admin & Mulai Aplikasi"

5. **Selesai!**
   - Setelah setup, Anda akan otomatis login sebagai admin
   - Aplikasi siap digunakan

### Keuntungan Metode Baru:
- ✅ Tidak perlu setup environment variables manual
- ✅ Interface yang user-friendly
- ✅ Validasi input yang lengkap
- ✅ Otomatis redirect jika admin belum ada
- ✅ Aman dan mudah digunakan
- ✅ Tidak ada file setup yang perlu dihapus

### Fitur Keamanan:
- 🔒 Password otomatis di-hash dengan bcrypt
- 🔒 Validasi input yang ketat
- 🔒 Cek duplikasi admin
- 🔒 Session management yang aman
- 🔒 Tidak ada file setup yang tertinggal

---

## Metode Lama: Environment Variables (Opsional)

Jika Anda ingin menggunakan metode lama dengan environment variables, masih bisa dilakukan:

### Langkah-langkah:

1. **Set Environment Variables di cPanel**
   ```
   AUTO_CREATE_ADMIN=true
   ADMIN_USERNAME=admin
   ADMIN_PASSWORD=Nr201105
   ADMIN_EMAIL=admin@azkazamdigital.com
   ADMIN_FULLNAME=Administrator Azkazamdigital
   ```

2. **Start Aplikasi**
   - Admin akan dibuat otomatis jika environment variables diset

**Catatan**: Metode ini masih didukung tapi tidak direkomendasikan karena metode baru lebih user-friendly.

---

## Metode 3: Manual via Web Interface

Jika kedua metode di atas tidak berhasil, gunakan halaman `/create-admin-web`:

1. Upload file `create-admin-web.html` ke server
2. Akses `https://yourdomain.com/create-admin-web`
3. Isi formulir dan submit
4. **Hapus file `create-admin-web.html` setelah selesai**

---

## Troubleshooting

### Jika masih error "Cannot GET":
1. Pastikan aplikasi Node.js sudah running
2. Cek Application URL di Node.js Selector
3. Set `APP_URL_PREFIX` di environment variables jika perlu

### Jika admin tidak terbuat:
1. Cek log aplikasi di cPanel
2. Pastikan `AUTO_CREATE_ADMIN=true` (bukan 'True' atau '1')
3. Pastikan database dapat diakses

### Keamanan:
- Ganti password default setelah login pertama
- Hapus environment variables setelah admin terbuat (opsional)
- Set `AUTO_CREATE_ADMIN=false` setelah setup selesai

---

## Environment Variables Lengkap

```bash
# Basic Configuration
PORT=3000
SESSION_SECRET=your-secret-key-here

# cPanel Configuration
APP_URL_PREFIX=          # Kosongkan jika tidak ada Application URL

# Auto Create Admin
AUTO_CREATE_ADMIN=true   # Set ke 'false' setelah admin terbuat
ADMIN_USERNAME=admin
ADMIN_PASSWORD=admin123
ADMIN_EMAIL=admin@yourdomain.com
ADMIN_FULLNAME=Administrator
```

**Catatan:** Setelah admin berhasil dibuat, Anda bisa mengubah `AUTO_CREATE_ADMIN=false` untuk mencegah pembuatan admin duplikat.