# Production Setup Guide - Afiliasi Azkazamdigital

## Pre-deployment Checklist

### 1. Environment Configuration
- [ ] Copy `.env.example` to `.env`
- [ ] Generate secure SESSION_SECRET: `node -e "console.log(require('crypto').randomBytes(64).toString('hex'))"`
- [ ] Set NODE_ENV=production
- [ ] Configure database path if needed

### 2. Security Setup
- [ ] Remove all demo/test data
- [ ] Create admin user manually (not through code)
- [ ] Verify no hardcoded passwords remain
- [ ] Ensure .env file is not accessible via web

### 3. Database Setup
```bash
# The app will create tables automatically on first run
# Create admin user manually after deployment
```

### 4. File Permissions (cPanel)
- Set folder permissions to 755
- Set file permissions to 644
- Ensure uploads directory is writable (755)

### 5. cPanel Deployment Steps

1. **Upload Files**
   - Upload all files except node_modules
   - Upload to public_html or subdirectory

2. **Install Dependencies**
   ```bash
   npm install --production
   ```

3. **Environment Setup**
   - Create .env file with production values
   - Ensure .env is not in public directory

4. **Start Application**
   - Use Node.js app manager in cPanel
   - Set startup file: server.js
   - Set Node.js version (14+ recommended)

5. **Create Admin User**
   - Access the application
   - Register first user
   - Manually update database to set role='admin'

### 6. Post-deployment
- [ ] Test all functionality
- [ ] Verify no sensitive data is exposed
- [ ] Check error logs
- [ ] Test file uploads
- [ ] Verify database connections

### 7. Security Notes
- Never commit .env file
- Use strong session secrets
- Regularly update dependencies
- Monitor error logs
- Backup database regularly

### 8. Troubleshooting
- Check Node.js version compatibility
- Verify file permissions
- Check error logs in cPanel
- Ensure all dependencies are installed

## Important Files Removed for Production
- Demo account credentials
- Sample products data
- Test analytics data
- Development secrets

## Environment Variables Required
```
SESSION_SECRET=your-secure-secret-here
NODE_ENV=production
PORT=3000
```